import os
import requests
import jpype
import jpype.imports
from jpype.types import *
from jpype import JImplements, JOverride
from typing import List

DEBUG = False
LIB_DIR = "java_lib"
# BUNDLED_JAR_URLS = [
#     'https://repo1.maven.org/maven2/de/learnlib/distribution/learnlib-distribution/0.17.0/learnlib-distribution-0.17.0-bundle.jar',
#     'https://repo1.maven.org/maven2/net/automatalib/distribution/automata-distribution/0.11.0/automata-distribution-0.11.0-bundle.jar'
# ]
BUNDLED_JAR_URLS = [
    'https://repo1.maven.org/maven2/de/learnlib/distribution/learnlib-distribution/0.17.0/learnlib-distribution-0.17.0-dependencies-bundle.jar',
    'https://repo1.maven.org/maven2/net/automatalib/distribution/automata-distribution/0.11.0/automata-distribution-0.11.0-dependencies-bundle.jar',
    'https://repo1.maven.org/maven2/org/slf4j/slf4j-simple/2.0.7/slf4j-simple-2.0.7.jar'
]
if DEBUG: BUNDLED_JAR_URLS[0] = 'learnlib-0.17.0-dependencies-bundle.jar'

JAVA_LIB_LOCAL_PATHS = []
for url in BUNDLED_JAR_URLS:
    filename = url.split('/')[-1]
    save_dir = os.path.join(os.path.dirname(__file__), LIB_DIR)
    save_path = os.path.join(save_dir, filename)
    JAVA_LIB_LOCAL_PATHS.append(save_path)


def download_java_libs(force=False):
    save_dir = os.path.join(os.path.dirname(__file__), LIB_DIR)
    if not os.path.exists(save_dir):
        os.mkdir(save_dir)

    for url, save_path in zip(BUNDLED_JAR_URLS, JAVA_LIB_LOCAL_PATHS):
        if not force and os.path.exists(save_path):
            continue
        try:
            response = requests.get(url)
            response.raise_for_status()
            
            with open(save_path, 'wb') as file:
                file.write(response.content)
            print(f"Downloaded '{url}' successfully.")
        except requests.exceptions.RequestException as e:
            print(f"Error downloading '{url}': {e}")


download_java_libs()
jpype.startJVM(classpath=JAVA_LIB_LOCAL_PATHS)

from net.automatalib.word import Word, WordBuilder
from net.automatalib.alphabet import Alphabet, Alphabets, SupportsGrowingAlphabet
from net.automatalib.automaton import DeterministicAutomaton, FiniteAlphabetAutomaton, UniversalDeterministicAutomaton
from net.automatalib.automaton.fsa import DFA, CompactDFA
from net.automatalib.automaton.UniversalDeterministicAutomaton import FullIntAbstraction
from net.automatalib.graph import Graph
from net.automatalib.visualization import Visualization, VisualizationHelper, DefaultVisualizationHelper, VPManager
from net.automatalib.visualization.dot import GraphVizBrowserVisualizationProvider
from net.automatalib.common.smartcollection import ArrayStorage, ElementReference, UnorderedCollection
from net.automatalib.serialization.learnlibv2 import LearnLibV2Serialization
from net.automatalib.serialization.saf import SAFSerializationDFA
from net.automatalib.serialization.taf import TAFSerializationDFA
from net.automatalib.util.automaton import Automata
from net.automatalib.util.automaton.fsa import DFAs
from de.learnlib import AccessSequenceProvider, Resumable
from de.learnlib.acex import AbstractCounterexample, AcexAnalyzer, AcexAnalyzers, OutInconsPrefixTransformAcex
from de.learnlib.oracle import MembershipOracle
from de.learnlib.oracle.MembershipOracle import DFAMembershipOracle
from de.learnlib.oracle.equivalence import DFASimulatorEQOracle
from de.learnlib.query import Query, DefaultQuery
from de.learnlib.datastructure.list import IntrusiveList, IntrusiveListElem, IntrusiveListElemImpl
from de.learnlib.datastructure.discriminationtree import SplitData
from de.learnlib.datastructure.discriminationtree.model import AbstractDiscriminationTree, AbstractTemporaryIntrusiveDTNode, AbstractDTNode
from de.learnlib.datastructure.discriminationtree.iterators import DiscriminationTreeIterators
from de.learnlib.algorithm import LearningAlgorithm
from de.learnlib.algorithm.LearningAlgorithm import DFALearner
from de.learnlib.algorithm.ttt.base import AbstractBaseDTNode, AbstractTTTHypothesis, BaseTTTDiscriminationTree, BlockList, HypothesisChangedException, IncomingList, OutputInconsistency, TTTTransition, TTTLearnerState, TTTState, AbstractTTTLearner
from de.learnlib.algorithm.ttt.dfa import TTTDTNodeDFA, TTTStateDFA, TTTHypothesisDFA, TTTLearnerDFA
from de.learnlib.algorithm.lstar.dfa import ExtensibleLStarDFA
from de.learnlib.algorithm.lstar.ce import ObservationTableCEXHandlers
from de.learnlib.algorithm.lstar.closing import ClosingStrategies
from de.learnlib.algorithm.rpni import BlueFringeEDSMDFA, BlueFringeMDLDFA
from java.util.function import Supplier
from java.io import FileInputStream, FileOutputStream, Serializable
from java.util import ArrayList, Arrays, Collections
from java.util.stream import Collectors
from java.lang import String, Integer
from java.lang import Class as JavaClass